/******************************************************
 * ArchC arch-specific resources header file.         *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_ARCH_H_
#define _NIOS32_ARCH_H_

#include "nios32_parms.H"
#include "ac_arch_dec_if.H"
#include "ac_storage.H"
#include "ac_memport.H"
#include "ac_sync_reg.H"
#include "ac_regbank.H"

#include "nios32_fmt_regs.H"

//! ArchC class for architecture-specific resources.

class nios32_arch: public ac_arch_dec_if<nios32_parms::ac_word, nios32_parms::ac_Hword>
{
 public:
  //! Program Counter register.
  ac_sync_reg<unsigned> ac_pc;
  //! Storage devices.
  ac_storage DM_stg;
  ac_memport<nios32_parms::ac_word, nios32_parms::ac_Hword> DM;
  ac_regbank<128, nios32_parms::ac_word, nios32_parms::ac_Dword> RB;
  nios32_fmt_F_IF_ID IF_ID;
  nios32_fmt_F_ID_EX ID_EX;
  nios32_fmt_F_EX_MEM EX_MEM;
  nios32_fmt_F_MEM_WB MEM_WB;
  nios32_fmt_F_STATUS ctl0;
  nios32_fmt_F_ISTATUS ctl1;
  nios32_fmt_F_WVALID ctl2;
  ac_sync_reg<nios32_parms::ac_word> ctl3;
  ac_sync_reg<nios32_parms::ac_word> ctl4;
  ac_sync_reg<nios32_parms::ac_word> ctl5;
  ac_sync_reg<nios32_parms::ac_word> ctl6;
  ac_sync_reg<nios32_parms::ac_word> ctl7;
  ac_sync_reg<nios32_parms::ac_word> ctl8;
  ac_sync_reg<nios32_parms::ac_word> ctl9;
  ac_sync_reg<nios32_parms::ac_word> pc;
  nios32_fmt_F_K k;

  //! Constructor.
  explicit nios32_arch(): ac_arch_dec_if<nios32_parms::ac_word, nios32_parms::ac_Hword>(nios32_parms::AC_MAX_BUFFER), ac_pc("ac_pc", 0), DM_stg("DM_stg", 5242880U), DM(*this, DM_stg), RB("RB"), IF_ID("IF_ID"), ID_EX("ID_EX"), EX_MEM("EX_MEM"), MEM_WB("MEM_WB"), ctl0("ctl0"), ctl1("ctl1"), ctl2("ctl2"), ctl3("ctl3", 0), ctl4("ctl4", 0), ctl5("ctl5", 0), ctl6("ctl6", 0), ctl7("ctl7", 0), ctl8("ctl8", 0), ctl9("ctl9", 0), pc("pc", 0), k("k")
  {
   //! Initializing.
   ac_mt_endian = nios32_parms::AC_MATCH_ENDIAN;
   IM = &DM;
   APP_MEM = &DM;
   return;
  }

  //! Destructor.
  virtual ~nios32_arch()
  {
   return;
  }

  //! Delegated read access to ac_pc.
  unsigned get_ac_pc()
  {
   return static_cast<unsigned>(ac_pc.read());
  }
};

#endif // _NIOS32_ARCH_H_
